<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('css/fontawesome.min.css')); ?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('css/adminlte.min.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.css" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/style.css')); ?>">
    <style>
        [class*=sidebar-dark-] {
    background-color: #392e54;
    /* background-color: #092d52; */
}
    </style>
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body class="hold-transition sidebar-mini">
    <div class="wrapper">
        <?php if(Session::has('success')): ?>
            <div class="toast m-auto" role="alert" aria-live="assertive" data-delay="2500" aria-atomic="true"
                style="position: absolute; left:0; right:0; top:200px; z-index: 999999;">
                <div class="toast-header">
                    <strong class="me-auto"><?php echo e(ucfirst($curr_url_2)); ?></strong>
                    <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body">
                    <?php echo e(Session::get('success')); ?>

                </div>
            </div>
        <?php endif; ?>
        <?php if(Session::has('error')): ?>
            <div class="toast m-auto" role="alert" aria-live="assertive" data-delay="2500" aria-atomic="true"
                style="position: absolute; left:0; right:0; top:200px; z-index: 999999;">
                <div class="toast-header">
                    <strong class="me-auto"><?php echo e(ucfirst($curr_url_2)); ?></strong>
                    <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body text-danger">
                    <?php echo e(Session::get('error')); ?>

                </div>
            </div>
        <?php endif; ?>

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                            class="fas fa-bars"></i></a>
                </li>
            </ul>

            <!-- Right navbar links -->
            <ul class="navbar-nav ml-auto">
                <button class="btn btn-primary" data-bs-target="#ImageModal" data-bs-toggle="modal"
                    id="openImageModal">Image</button>
                <li class="nav-item dropdown">
                    <a class="nav-link" data-toggle="dropdown" href="#" aria-expanded="false">
                        <?php echo e(Auth::user()->name); ?>

                    </a>
                    <div class="dropdown-menu dropdown-menu-right" style="left: inherit; right: 0px;">
                        <a href="<?php echo e(route('profile.show')); ?>" class="dropdown-item">
                            <i class="mr-2 fas fa-file"></i>
                            <?php echo e(__('My profile')); ?>

                        </a>
                        <div class="dropdown-divider"></div>
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <a href="<?php echo e(route('logout')); ?>" class="dropdown-item"
                                onclick="event.preventDefault(); this.closest('form').submit();">
                                <i class="mr-2 fas fa-sign-out-alt"></i>
                                <?php echo e(__('Log Out')); ?>

                            </a>
                        </form>
                    </div>
                </li>
            </ul>
        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="<?php echo e(route('home')); ?>" class="brand-link">
                
                <span class="brand-text font-weight-light"><?php echo e($website_name); ?></span>
            </a>

            <?php echo $__env->make('layouts.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <div class="p-5">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
        <!-- /.content-wrapper -->

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
            <div class="p-3">
                <h5>Title</h5>
                <p>Sidebar content</p>
            </div>
        </aside>
        <!-- /.control-sidebar -->

        <!-- Main Footer -->
        <footer class="main-footer">
            <!-- To the right -->
            <div class="float-right d-none d-sm-inline">
                Designed & Developed by <?php echo e($dev); ?>

            </div>
            <!-- Default to the left -->
            <strong>Copyright &copy; 2014-<?php echo e(Date('Y')); ?> <a href="https://nextmsc.com/"
                    target="__blank"><?php echo e($website_name); ?></a>.</strong>
            All rights reserved.
        </footer>
    </div>
    <div class="modal fade" id="ImageModal" aria-hidden="true" aria-labelledby="ImageModalLabel" tabindex="-1">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="ImageModalLabel">Images</h1>
                    <button class="btn btn-primary mx-auto" data-bs-target="#AddImageModal"
                        data-bs-toggle="modal">Add Image</button>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="imageModalBody">
                    <table class="table table-bordered image_datatable">
                        <thead>
                            <tr>
                                <th>Title</th>
                                <th>Image</th>
                                <th>Uploaded At</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">

                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="AddImageModal" aria-hidden="true" aria-labelledby="ImageModalLabel2"
        tabindex="-1">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="ImageModalLabel2">Add Image</h1>
                    <button class="btn btn-primary mx-auto" data-bs-target="#ImageModal" data-bs-toggle="modal"
                        id="showImages">View
                        All Image</button>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('admin.image.store')); ?>" method="post" id="ajaxForm"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if (isset($component)) { $__componentOriginal87a1e5c5fea0f057d989b314d8c47a16 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal87a1e5c5fea0f057d989b314d8c47a16 = $attributes; } ?>
<?php $component = App\View\Components\Form\InputComponent::resolve(['name' => 'title','label' => 'Title','placeholder' => 'Title','value' => ''.e(old('title')).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.input-component'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Form\InputComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal87a1e5c5fea0f057d989b314d8c47a16)): ?>
<?php $attributes = $__attributesOriginal87a1e5c5fea0f057d989b314d8c47a16; ?>
<?php unset($__attributesOriginal87a1e5c5fea0f057d989b314d8c47a16); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal87a1e5c5fea0f057d989b314d8c47a16)): ?>
<?php $component = $__componentOriginal87a1e5c5fea0f057d989b314d8c47a16; ?>
<?php unset($__componentOriginal87a1e5c5fea0f057d989b314d8c47a16); ?>
<?php endif; ?>
                        
                        <?php if (isset($component)) { $__componentOriginal87a1e5c5fea0f057d989b314d8c47a16 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal87a1e5c5fea0f057d989b314d8c47a16 = $attributes; } ?>
<?php $component = App\View\Components\Form\InputComponent::resolve(['name' => 'image','label' => 'Image','type' => 'file','placeholder' => 'Image','value' => ''.e(old('image')).'','required' => 'true'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.input-component'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Form\InputComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal87a1e5c5fea0f057d989b314d8c47a16)): ?>
<?php $attributes = $__attributesOriginal87a1e5c5fea0f057d989b314d8c47a16; ?>
<?php unset($__attributesOriginal87a1e5c5fea0f057d989b314d8c47a16); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal87a1e5c5fea0f057d989b314d8c47a16)): ?>
<?php $component = $__componentOriginal87a1e5c5fea0f057d989b314d8c47a16; ?>
<?php unset($__componentOriginal87a1e5c5fea0f057d989b314d8c47a16); ?>
<?php endif; ?>
                        <button class="btn btn-success" id="submitBtn">Save</button>
                    </form>
                </div>
                <div class="modal-footer">

                </div>
            </div>
        </div>
    </div>
    <!-- ./wrapper -->

    <!-- REQUIRED SCRIPTS -->
    

    <!-- AdminLTE App -->
    <script src="<?php echo e(asset('js/adminlte.min.js')); ?>" defer></script>
    <script src="https://code.jquery.com/jquery-3.7.1.slim.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script type="text/javascript"
        src="https://cdn.datatables.net/v/dt/jq-3.6.0/dt-1.12.1/kt-2.7.0/r-2.3.0/datatables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="<?php echo e(asset('ckeditor-full/ckeditor/ckeditor.js')); ?>" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    
    
    <script>
        const displayImagePreview = (imagePathId, previewContainerId) => {
            var container = document.getElementById(previewContainerId);
            container.innerHTML = "<img src='" + $('#' + imagePathId).val() +
                "' alt='User Image' height='50' width='50' >";
        }

        const displayVideoPreview = (videoPathId, previewContainerId) => {
            var container = document.getElementById(previewContainerId);
            var videoUrl = $('#' + videoPathId).val();
            var videoId = extractYouTubeVideoId(videoUrl);
            var iframeCode = '<iframe width="560" height="315" src="https://www.youtube.com/embed/' + videoId +
                '" frameborder="0" allowfullscreen></iframe>';
            container.innerHTML = iframeCode;
        }

        const extractYouTubeVideoId = (url) => {
            var match = url.match(/watch\?v=([^\&]+)/);
            return match ? match[1] : null;
        }
        $(function() {
            $('.toast').toast('show');
            // $('.select2').select2();

            const loadDataTable = () => {
                $('.image_datatable').DataTable().destroy();
                $('.image_datatable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "<?php echo e(route('admin.image.index')); ?>",
                    columns: [{
                            data: 'title',
                            name: 'title'
                        },
                        {
                            data: 'image_url',
                            name: 'image_url'
                        },
                        {
                            data: 'created_at',
                            name: 'Date'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: true,
                            searchable: true
                        },
                    ]
                });
            }
            $('#openImageModal, #showImages').click(function() {
                loadDataTable();
                $('#ImageModal').modal('show');
            });
        });
        let table = new DataTable('#commondatatable', {
            responsive: true
        });
        const copyToClipboard = (text) => {
            navigator.clipboard.writeText(text).then(function() {
                // Swal.fire("Copied to clipboard");
                showToast('Text copied to clipboard!');
            }).catch(function(err) {
                // console.error('Unable to copy text to clipboard', err);
            });
        }

        // const copyToClipboard = (text) => {
        //     if (navigator.clipboard) {
        //         navigator.clipboard.writeText(text).then(function() {
        //             showToast('Text copied to clipboard!');
        //         }).catch(function(err) {
        //             console.error('Unable to copy text to clipboard', err);
        //         });
        //     } else {
        //         console.warn('Clipboard API not supported, using fallback');
        //         fallbackCopyTextToClipboard(text);
        //     }
        // };

        // const fallbackCopyTextToClipboard = (text) => {
        //     const textArea = document.createElement('textarea');
        //     textArea.value = text;
        //     document.body.appendChild(textArea);
        //     const range = document.createRange();
        //     range.selectNode(textArea);
        //     const selection = window.getSelection();
        //     selection.removeAllRanges();
        //     selection.addRange(range);
        //     try {
        //         document.execCommand('copy');
        //         showToast('Text copied to clipboard!');
        //     } catch (err) {
        //         console.error('Unable to copy text to clipboard', err);
        //     }
        //     document.body.removeChild(textArea);
        //     selection.removeAllRanges();
        // };

        const showToast = (message) => {
            const toast = document.createElement('div');
            toast.classList.add('toast');
            toast.classList.add('show');
            toast.setAttribute('role', 'alert');
            toast.setAttribute('aria-live', 'assertive');
            toast.setAttribute('aria-atomic', 'true');
            const toastBody = document.createElement('div');
            toastBody.classList.add('toast-body');
            toastBody.textContent = message;
            toast.appendChild(toastBody);
            toast.style.position = 'fixed';
            toast.style.bottom = '20px';
            toast.style.right = '20px';
            document.body.appendChild(toast);
            setTimeout(() => {
                $(toast).toast('hide');
            }, 3000);
        }
        $(document).ready(function() {
            $('#ajaxForm').on('submit', function(e) {
                e.preventDefault();
                saveFormData();
            });
        });

        const imageUpdateStatus = (id, checkbox) => {
            var status = checkbox.checked ? 1 : 0;
            $.ajax({
                url: '<?php echo e(route('admin.image.status')); ?>',
                type: 'POST',
                dataType: 'json',
                data: {
                    id: id,
                    _token: "<?php echo e(csrf_token()); ?>",
                    status: status,
                },
                success: function(response) {
                    // Handle the success response
                    console.log('Status updated successfully');
                },
                error: function(error) {
                    // Handle the error response
                    console.error('Failed to update status');
                }
            });
        }

        function saveFormData() {
            var form = $('#ajaxForm')[0];
            var formData = new FormData(form);
            $.ajax({
                url: form.action,
                method: form.method,
                data: formData,
                processData: false,
                dataType: 'json',
                contentType: false,
                success: function(response) {
                    // console.log(response);
                    showToast('Image Uploaded Successfully');
                    $('#showImages').trigger('click');
                    form.reset();
                },
                error: function(error) {
                    console.error(error);
                }
            });
        }

        // CKEDITOR.replaceClass ('ckeditor');
    </script>

    <?php echo $__env->yieldContent('scripts'); ?>
    <script>
        $('table').addClass('table-striped table-hover');
        $('#commondatatable').addClass('table-responsive');
    </script>
</body>

</html>
<?php /**PATH D:\Tiksha office\vipulgarg\resources\views/layouts/app.blade.php ENDPATH**/ ?>