<div class="form-floating mb-2">
    <?php if($type === 'textarea'): ?>
        <textarea class="form-control <?php echo e($class); ?>" name="<?php echo e($name); ?>" placeholder="<?php echo e($placeholder); ?>"
            id="<?php echo e($name); ?>" rows="4" cols="50"><?php echo e($value); ?></textarea>
    <?php elseif($type === 'select'): ?>
        <select id="<?php echo e($name); ?>" name="<?php echo e($name); ?>" class="form-select <?php echo e($class); ?>"
            <?php if($required): ?> required <?php endif; ?>>
            <option class='cusoption' value="" disabled selected ><?php echo e($label); ?></option>
            <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $optionLabel => $optionValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option  class='cusoption' value="<?php echo e($optionValue); ?>" <?php echo e($optionValue == $value ? 'selected' : ''); ?>>
                    <?php echo e($optionLabel); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    <?php elseif($type === 'radio'): ?>
        <div class="d-flex">
            <h5 class="mr-5">
                <?php echo e($placeholder); ?>

                <?php if($required): ?>
                    <span class="text-danger"> * </span>
                <?php endif; ?>
            </h5>

            <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $optionLabel => $optionValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="form-check form-check-inline">
                <input class="form-check-input <?php echo e($class); ?>" type="radio" name="<?php echo e($name); ?>"
                    id="<?php echo e($name . '_' . $loop->index); ?>" value="<?php echo e($optionValue); ?>"
                    <?php echo e($optionValue == $value ? 'checked' : ''); ?> <?php if($required): ?> required <?php endif; ?> >
                <label class="form-check-label" for="<?php echo e($name . '_' . $loop->index); ?>">
                    <?php echo e($optionLabel); ?>

                </label>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php elseif($type === 'number'): ?>
        <input type="number" class="form-control <?php echo e($class); ?>" name="<?php echo e($name); ?>" id="<?php echo e($name); ?>"
            placeholder="<?php echo e($placeholder); ?>" value="<?php echo e($value); ?>"  <?php if(isset($min)): ?> min="<?php echo e($min); ?>" <?php endif; ?>
            <?php if(isset($max)): ?> max="<?php echo e($max); ?>" <?php endif; ?>  <?php if($required): ?> required <?php endif; ?> >
        <label for="<?php echo e($name); ?>"><?php echo e($label); ?> <?php if($required): ?>
                <span class="text-danger"> * </span>
            <?php endif; ?> </label>
    <?php else: ?>
        <input type="<?php echo e($type); ?>" class="form-control <?php echo e($class); ?>" name="<?php echo e($name); ?>"
            id="<?php echo e($name); ?>" placeholder="<?php echo e($placeholder); ?>" value="<?php echo e($value); ?>"
            <?php if($required): ?> required <?php endif; ?> >
        <label for="<?php echo e($name); ?>"><?php echo e($label); ?> <?php if($required): ?>
                <span class="text-danger"> * </span>
            <?php endif; ?> </label>
    <?php endif; ?>
    <?php $__errorArgs = [$name];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="text-danger"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>
<?php /**PATH /var/www/html/vipulgarg/resources/views/components/form/input-component.blade.php ENDPATH**/ ?>