<!DOCTYPE html>
<html>

<head>
  <title>Reports</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
  integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  
  
  <style>
    .margin-bottom-20 {
      margin-bottom: 20px !important;
    }
    .flex {
      display: flex;
      display: -ms-flexbox;
      flex-wrap: wrap;
      list-style: none;
      margin: 0;
      padding: 0;
    }
    .flex--top {
      align-items: flex-start;
    }
    .flex--spacing20 {
      margin-bottom: -20px;
      margin-left: -20px;
    }
    .margin-neg-bottom-10 {
      margin-bottom: -10px !important;
    }
    .flex__item {
      display: flex;
    }
    .flex__item--basis {
      flex-basis: 0;
    }
    .flex__item--grow {
      -ms-flex-positive: 1;
      flex-grow: 1;
    }
    .flex--spacing20>.flex__item {
      float: none;
      padding-bottom: 20px;
      padding-left: 20px;
    }
    .flex--spacing10>.flex__item {
      float: none;
      padding-bottom: 10px;
      padding-left: 10px;
    }
    a{
      text-decoration: none;
    }
    .reportClusterTag {
      background-color: rgba(69, 95, 124, .1);
      border-radius: 2px;
      color: #455f7c;
      display: none;
      font-size: .75rem;
      font-weight: 600;
      padding: 3px 5px;
    }
    .reportClusterTag--country {
      background-color: rgba(0, 103, 222, .1);
      color: #0067de;
      display: inline-block;
    }
    .reportClusterTag--politics {
      background-color: rgba(20, 121, 111, .15);
      color: #14796f;
      display: inline-block;
    }
    .border-bottom-gray10-1 {
      border-bottom: 1px solid #e6e6e6;
    }
    .text-color--dark-blue-gray {
      color: #455f7c !important;
    }
    .text-semibold {
      font-weight: 600 !important;
    }
    .flex--spacing25>.flex__item {
      float: none;
      padding-bottom: 25px;
      padding-left: 25px;
    }
    .hover--zoom, .hover--zoom:hover {
      transition: transform .2s ease-in-out;
    }
    .reportResult__thumbnail {
      box-shadow: 0 5px 26px 0 rgba(67,94,131,.15);
      height: auto;
      width: 178px;
    }
    .hover--zoom:hover {
      transform: translateY(-10px);
    }
    .hover--zoom, .hover--zoom:hover {
      transition: transform .2s ease-in-out;
    }
    .padding-bottom-10 {
      padding-bottom: 10px !important;
    }
    .page {
      display: -ms-flexbox;
      display: flex;
      -ms-flex-direction: column;
      flex-direction: column;
      -ms-flex-wrap: wrap;
      flex-wrap: wrap;
      position: relative;
      text-align: left;
      transition: transform .3s, top 0s;
      width: 100%;
    }
    .display-inline {
      display: inline !important;
    }
    
    @media only screen and (max-width: 767px){
      .flex--spacing20>.flex__item {
        flex: 1 100%;
        padding-bottom: 10px;
        padding-left: 10px;
      }
      .hideMobile {
        display: none !important;
      }
      .flex--spacing25>.flex__item {
        flex: 1 100%;
        padding-bottom: 10px;
        padding-left: 10px;
      }
      .reportResultreportResult__content {
        background-color: #fff;
        border-radius: 5px;
        padding: 20px;
      }
      spacing20>.flex__item:last-child {
        margin-bottom: 0;
      }
      .flex--spacing20>.flex__item {
        flex: 1 100%;
        padding-bottom: 10px;
        padding-left: 10px;
      }
      .reportResult__content {
        background-color: #fff;
        border-radius: 5px;
        padding: 20px;
      }
    }
  </style>
</head>

<body>
  
  <div class="container">
    <div class="row">
      <div>
        <h2 class="h6 font-size-s margin-bottom-20"><strong>Total results:</strong> <?php echo e($reportcount); ?> </h2>
      </div>

      <?php
        // echo "<pre>";
        // print_r($reports[0]->reportid);
        // die();
      ?>
      
      <div>

        <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          
        <a href="<?php echo e(route('public_report_show', ['reportid' => $report->reportid,'tool_table_name' => $report->tool_table_name])); ?>" class="flex flex--top flex--spacing20 margin-neg-bottom-10 text--linkReset">
          
          <div class="flex__item hideMobile">
            <img src="<?php echo e($report->image_path1); ?>" width="178" height="100" alt="<?php echo e($report->report_title); ?> " class="__thumbnail hover--zoom">
          </div>

          <div class="flex__item flex__item--basis flex__item--grow display-block">

            <div class="reportResult__content">
              <h3 class="h4 text-semibold margin-bottom-0">
                <?php echo e($report->report_title); ?> 
              </h3>
              <p class="text-color--dark-blue-gray margin-top-15 padding-bottom-10 border-bottom-gray10-1">
                <?php echo e($report->description); ?> 
              </p>
              <div class="flex flex--spacing25 font-size-s margin-top-10">
                <div class="flex flex--spacing25 font-size-s margin-top-10">
                  <span class="flex__item display-inline padding-bottom-10"> Price <span class="text-semibold">INR <?php echo e($report->price); ?> </span></span>
                  <span class="flex__item display-inline padding-bottom-10"><i aria-hidden="true" class="fa fa-clock-o"></i> Published in 
                    <span class="text-semibold">
                     <?php echo e(\Carbon\Carbon::parse($report->p_date)->format('F Y')); ?>

                    </span>
                  </span> 
                </div>
              </div>
            </div>

          </div>


        </a>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


        

                  </div>
                </div>
              </div>
            </body>
            </html><?php /**PATH D:\Repos\Paritosh\vipulgarg1-cms-e154e3c62caf\resources\views/reportlist.blade.php ENDPATH**/ ?>