<!DOCTYPE html>
<html>

<head>
  <title><?php echo e($report->seo_title); ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
    integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="http://127.0.0.1:8000/css/fontawesome.min.css">
    <meta name="description" content="<?php echo e($report->meta_description); ?>">
    <meta name="keywords" content="<?php echo e($report->meta_keyword); ?>">
  <style>
    .grid {
      column-gap: 1rem;
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      grid-template-rows: auto;
    }

    .marginTop__xs--100 {
      margin-top: 1rem;
    }

    .leftColumn--firstContainer {
      grid-column: 1 / span 8;
    }

    .introduction__image {
      box-shadow: 0 6px 10px rgba(0, 0, 0, .03), 0 1px 18px rgba(0, 0, 0, .07), 0 5px 26px rgba(69, 95, 124, .15);
      height: auto;
      margin-right: 1rem;
      position: relative;
      width: 100%;
      z-index: 1;
    }

    .marginTop__xs--100 {
      margin-top: 1rem;
    }

   
    .copy--1,
    .copy--2 {
      font-weight: 400;
      line-height: 1.5;
    }

    .copy--1 {
      font-size: 1rem;
    }

    .Box_container {
      border-radius: 0.25rem;
      border-top: 0.25rem solid #0666e5;
      padding: 1rem;
      pointer-events: auto;
      position: relative;
      z-index: 4;
    }

    .panel {
      background-color: #fff;
      border-radius: 0.25rem;
      box-shadow: 0 5px 26px rgba(69, 95, 124, .15);
    }

    .Box_detailsTable,
    .Box_priceTable {
      border: none;
      border-collapse: collapse;
      margin-top: 1rem;
      width: 100%;
    }

    .Box_detailsTableCell:nth-child(4n-7),
    .Box_priceTableCell:nth-child(4n-7) {
      font-weight: 600;
      width: 110px;
    }

    .Box_detailsTableCell,
    .Box_priceTableCell {
      padding: 0.25rem 0;
      vertical-align: middle;
    }

    .Box_price {
      border-top: 1px solid #e5e5e5;
      margin-top: 1rem;
    }

    .summaryBox .reportPrice {
      display: grid;
      gap: 0.25rem;
    }

    .h--5,
    .h--6 {
      font-weight: 300;
      line-height: 1.25;
    }

    .h--5 {
      font-size: clamp(1.25rem, calc(.87rem + 1.37vw), 1.75rem);
    }

    .Box_buttonDownload {
      position: relative;
      text-decoration: none;
      transition: background-color .3s ease-in;
    }

    .button--fullWidth {
      min-width: 100%;
    }

    .button--primary {
      background-color: #0666e5;
      border-color: #0666e5;
      color: #fff;
    }
    .button--small {
    font-size: .875rem;
    line-height: 2;
    min-height: 2.5rem;
    padding: 0 1rem;
}
.button {
    align-items: center;
    border-radius: 0.25rem;
    border-style: solid;
    border-width: 1px;
    display: flex;
    flex-direction: row;
    font-family: Open Sans, Open Sans fallback, -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;
    font-weight: 600;
    gap: 0.5rem;
    justify-content: center;
    margin: 0;
    text-decoration: none;
    text-overflow: ellipsis;
    transition: background-color .3s, color .3s;
}
.Box_footer, .container {
    margin-top: 1rem;
}
.reasonsToBuy {
    border: 1px solid #e5f1ff;
    border-radius: 0.25rem;
    padding: 1.5rem 2rem;
}
.marginLeft__xs--50 {
    margin-left: 0.5rem;
}
.marginTop__md--150 {
    margin-top: 1.5rem;
}
.reasons_listItem {
    align-items: center;
    display: flex;
    font-size: .875rem;
    font-weight: 400;
    line-height: 1.5;
}
.list__item--none {
    list-style-type: none;
}
.reasons_list {
    padding: 0;
}
.rightColumn {
    grid-column: 1 / -1;
    position: relative;
}
@media (min-width: 64rem) {
      .rightColumn {
        grid-column: 9 / span 4;
      }

      .marginRight__lg--250 {
        margin-right: 2.5rem;
      }

      .introduction__image {
        float: left;
        width: 37.5%;
      }
    }

@media (min-width: 42.5rem){
.asideContent {
    padding-top: 2.5rem;
}
.marginTop__md--0 {
    margin-top: 0;
}
}
  </style>
</head>

<body>
   

  <div class="container">
    <div class="reportContent grid">
      <div class="leftColumn leftColumn--firstContainer">
        <section id="introduction"
          class="introduction marginTop__xs--100 marginTop__md--250 marginRight__md--200 marginRight__lg--250 copy copy--1"
          aria-label="Introduction of the report DoorDash">
          <div>
            <h1 id="introductionTitle" class="introduction__title headline h--4">
              <?php echo e($report->report_title); ?> 
            </h1>
            <p class="introduction__title--sub marginTop__xs--50">
              <?php echo e($chartdata['heading']['table_name']); ?>

            </p>
          </div>
          
          <div>
            <!-- <div class="introduction__coverContainer marginTop__xs--100">
              <picture>
                  <img
                  src="<?php echo e($report->image_path1); ?>" alt="DoorDash"
                  class="introduction__image" width="100%" style="width:100%">
              </picture>
              
            </div> -->
            
          </div>
          <div class="introduction__coverContainer marginTop__xs--100 non-printable">
            <h3><?php echo e($chartdata['heading']['table_name']); ?></h3>
          </div>
          <div class="chart">
            <h2></h2>
            
            <canvas id="myChart"></canvas>
          </div>
          <div class="copy--1 non-printable">
 
                <!-- <p><?php echo e($report->description); ?> </p> -->
                <p><?php echo $report->write_up; ?> </p>
              </div>
        </section>

      </div>

  


      <div class="rightColumn non-printable" style="width:400px">
        <aside class="asideContent__wrapper" aria-labelledby="summaryBoxReportTitle">
          <div class="asideContent marginTop__xs--200 marginTop__md--0">
            <div class="summaryBox Box_container panel" data-summary-box="">
              <header class="Box_heading">
                <h2 id="summaryBoxReportTitle" class="Box_headingRoofTitle kicker">
                  Report Details
                </h2>
              </header>
               
              <div class="Box_details copy copy--2 marginTop__xs--100">
                <table class="Box_detailsTable"  style="width:400px">
                  <tbody>
                    <tr class="Box_detailsTableRow">
                      <td class="Box_detailsTableCell" style="width:180px">
                      Release Date
                      </td>
                      <td class="Box_detailsTableCell">
                      <?php echo e($report->release_date); ?>

                      </td>
                    </tr>
                    <tr class="Box_detailsTableRow">
                      <td class="Box_detailsTableCell" style="width:180px">
                      Region
                      </td>
                      <td class="Box_detailsTableCell">
                      <?php echo e($report->region); ?>

                      </td>
                    </tr>
                    <tr class="Box_detailsTableRow">
                      <td class="Box_detailsTableCell" style="width:180px">
                      Survey Time Period
                      </td>
                      <td class="Box_detailsTableCell"><?php echo e($report->survey_time_period); ?></td>
                    </tr>
                    <tr class="Box_detailsTableRow">
                      <td class="Box_detailsTableCell" style="width:180px">
                      Supplementary Notes
                      </td>
                      <td class="Box_detailsTableCell"><?php echo e($report->supplementary_notes); ?></td>
                      <!-- <td class="Box_detailsTableCell"><?php echo e(\Carbon\Carbon::parse($report->p_date)->format('F Y')); ?></td> -->
                    </tr>
                     
                  </tbody>
                </table>
                <?php if($report->is_xls): ?>
                <div tyle="margin-top:10px;">
                <button onclick="exportToExcel()" class="btn btn-outline-secondary" style="width:200px;"><i class="fas fa-file-excel fa-2xl" style="color: #1fa87f;"></i> &nbsp;&nbsp;Export to Excel</button>
                </div>
                <?php endif; ?>
                <?php if($report->is_pdf): ?>
                <div style="margin-top:10px;width:200px;">
                <button onclick="printCanvas()" class="btn btn-outline-secondary" style="width:200px;"><i class="fas fa-file-pdf fa-2xl" style="color: #e11414;"></i> &nbsp;&nbsp;Export to PDF</button>
                  </div>
                <?php endif; ?>
                <?php if($report->is_png): ?>
                  <div style="margin-top:10px;width:200px;">
                <button onclick="exportImage()" class="btn btn-outline-secondary" style="width:200px;"><i class="fas fa-solid fa-images" style="color: #74C0FC;"></i> &nbsp;&nbsp;Export to Image</button>

                </div>
                <?php endif; ?>
              </div>
              <!-- <div class="Box_price">
                <table class="Box_priceTable copy--2">
                  <tbody>
                    <tr class="Box_priceTableRow">
                      <td class="Box_priceTableCell Box_priceTitle">
                        Price
                      </td>
                      <td class="Box_priceTableCell Box_priceAmount"><span class="reportPrice h--5">
                        INR <?php echo e($report->price); ?></span></td>
                    </tr>
                  </tbody>
                </table>
              </div> -->
              <!-- <footer class="Box_footer">
                <div class="Box_buttons ">
                  <div class="Box_buttonElement" data-openmodal="premiumDossierModal"><a
                      class="Box_buttonDownload button button--small button--primary button--fullWidth"
                      href="/31/direct/purchase/study/1/create/165358" data-summary-box-button=""
                      data-gtm="studyButton__orderStudy--dossier">
                      Order report
                    </a></div>
                </div>
              </footer> -->
            </div>
            <div class="reasonsToBuy marginTop__xs--200 marginTop__md--150">
              <ul class="reasons_list list">
                <li class="reasons_listItem list__item list__item--none "><svg class="reasons_icon"
                    aria-hidden="true" width="16" height="16">
                    <use href="#iconMagnifyingGlassRegular"></use>
                  </svg><span class="marginLeft__xs--50">
                    Comprehensive data insights
                  </span></li>
                <li class="reasons_listItem list__item list__item--none marginTop__xs--50"><svg
                    class="reasons_icon" aria-hidden="true" width="16" height="16">
                    <use href="#iconChartBarVerticalRegular"></use>
                  </svg><span class="marginLeft__xs--50">
                    Includes all relevant statistics
                  </span></li>
                <li class="reasons_listItem list__item list__item--none marginTop__xs--50"><svg
                    class="reasons_icon" aria-hidden="true" width="16" height="16">
                    <use href="#iconUserRegular"></use>
                  </svg><span class="marginLeft__xs--50">
                    Compiled by our industry experts
                  </span></li>
              </ul>
            </div>
          </div>
        </aside>
      </div>

    </div>
  </div>
  
   

</body>
 


<!-- Include Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
 <!-- Add this to the head section of your HTML file -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.5/xlsx.full.min.js"></script>


<style>
        /* Define styles for printing */
        @media print {
            /* Hide elements with the class "non-printable" */
            .non-printable {
                display: none !important;
            }
        }
    </style>

<script>

      function exportImage(){
        var chartCanvas = document.getElementById("myChart");
          // Create an image from the canvas data URL
        // Create an image from the canvas data URL
        var chartImage = new Image();
        chartImage.src = chartCanvas.toDataURL('image/png');

        // Create a download link
        var downloadLink = document.createElement('a');
        downloadLink.href = chartImage.src;
        downloadLink.download = 'chart.png';

        // Append the link to the body
        document.body.appendChild(downloadLink);

        // Simulate a click on the link to trigger the download
        downloadLink.click();

        // Remove the link from the body
        document.body.removeChild(downloadLink);
      }

  function printCanvas() {
        // Get the canvas element
        var canvas = document.getElementById('myChart');

         // Get the canvas element
         

// Create an image element with the canvas data URL
      var canvasImage = new Image();
        canvasImage.src = canvas.toDataURL('image/png');

       
        var hiddenDiv = document.createElement('div');
        hiddenDiv.style.display = 'none';
        hiddenDiv.appendChild(canvasImage);
        document.body.appendChild(hiddenDiv);
 
        window.print();

        
        document.body.removeChild(hiddenDiv);

      // Trigger the print function
      printWindow.print();
    }
    function exportToExcel() {
        // Sample data
        var data = <?php echo json_encode($excellData); ?>;
        var workbook = XLSX.utils.book_new();
        var worksheet = XLSX.utils.aoa_to_sheet(data);
        XLSX.utils.book_append_sheet(workbook, worksheet, 'Sheet1');
        XLSX.writeFile(workbook, "<?php echo e($chartdata['heading']['table_name']); ?>.xls");
    }
</script>
<script>
  var ctx = document.getElementById('myChart').getContext('2d');
  var myChart = new Chart(ctx, {
      type: '<?php echo e($report->chart_type); ?>',
      data: {
          labels: [
              <?php $__currentLoopData = $chartdata['chart_heading']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  '<?php echo e($year); ?>',
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ],
          datasets: [
              <?php $__currentLoopData = $chartdata['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $dataSet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  {
                      label: '<?php echo e($dataSet['label']); ?>',
                      data: [
                          <?php $__currentLoopData = $dataSet['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <?php echo e($value); ?>,
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      ],
                      borderColor: getRandomColor(<?php echo e($index); ?>),
                      backgroundColor: getRandomColor(<?php echo e($index); ?>),
                      fill: false
                  },
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          ]
      },
      options: {
          responsive: true,
          maintainAspectRatio: true,
          scales: {
              yAxes: [{
                  ticks: {
                      beginAtZero: true
                  }
              }]
          }
      }
  });

  // Function to generate random color for each dataset
  function getRandomColor(index) {
    const colors = [
          '#3498db',
          '#2ecc71',
          '#e74c3c',
          '#f39c12',
          '#9b59b6',
          '#34495e',
          '#1abc9c',
          '#e67e22',
          '#d35400',
          '#27ae60',
      ];
      return colors[index]  
    // var letters = '0123456789ABCDEF';
      // var color = '#';
      // for (var i = 0; i < 6; i++) {
      //     color += letters[Math.floor(Math.random() * 16)];
      // }
      // return color;
  }

    // Export to PDF function
    document.getElementById('export-pdf').addEventListener('click', function() {
        var doc = new jsPDF();
        doc.text("Chart Data", 10, 10);
        doc.autoTable({html: '#myChart'});
        doc.save('chart_data.pdf');
    });

    // Export to Excel function
    document.getElementById('export-excel').addEventListener('click', function() {
        var wb = XLSX.utils.book_new();
        wb.SheetNames.push("ChartData");
        var ws_data = [[]];
        ws_data[0] = ["Year", <?php $__currentLoopData = $chartdata['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dataSet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> '<?php echo e($dataSet['label']); ?>', <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>];
        <?php for($i = 0; $i < count($chartdata['chart_heading']); $i++): ?>
            ws_data.push(['<?php echo e($chartdata['chart_heading'][$i]); ?>',
            <?php $__currentLoopData = $chartdata['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dataSet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo e($chartdata['data'][$loop->index]['data'][$i]); ?>,
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]);
        <?php endfor; ?>
        var ws = XLSX.utils.aoa_to_sheet(ws_data);
        wb.Sheets["ChartData"] = ws;
        var wbout = XLSX.write(wb, {bookType:'xlsx', type:'binary'});
        function s2ab(s) {
            var buf = new ArrayBuffer(s.length);
            var view = new Uint8Array(buf);
            for (var i=0; i<s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
            return buf;
        }
        saveAs(new Blob([s2ab(wbout)],{type:"application/octet-stream"}), 'chart_data.xlsx');
    });

</script>




</html><?php /**PATH /var/www/html/vipulgarg/resources/views/reportview.blade.php ENDPATH**/ ?>