<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\{
    CommonController,
    NewsController,
    NewsCommentController,
    NewsCategoryController,
    NewsletterController,
    BlogController,
    BlogCommentController,
    BlogCategoryController,
    FaqController,
    ReportController,
    ApiReportController,
    ReportChartController,
    ReportCategoryController,
    ReportSubCategoryController,
    CareerController,
    EnquiryController,
    ImageController,
    OurSectionController,
    TestimonialController,
    PublicReportsController,
};

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('frontend.layout.app');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/reports', [App\Http\Controllers\PublicReportsController::class, 'index'])->name('public_reports');
Route::get('/report/{reportid}/{slug}', [App\Http\Controllers\PublicReportsController::class, 'show'])->name('public_report_show');

Route::middleware(['auth', 'verified'])->name('admin.')->prefix('admin')->group(function () {
    Route::resource('/roles', RoleController::class, ['names' => 'roles']);
    Route::resource('/permissions', PermissionController::class, ['names' => 'permissions']);
    Route::post('/roles/{role}/permissions', [RoleController::class, 'givePermission'])->name('roles.permissions');
    Route::delete('/roles/{role}/permissions/{permission}', [RoleController::class, 'revokePermission'])->name('roles.permissions.revoke');
    Route::post('/permissions/{permission}/roles', [PermissionController::class, 'assignRole'])->name('permissions.roles');
    Route::delete('/permissions/{permission}/roles/{role}/', [PermissionController::class, 'removeRole'])->name('permissions.roles.remove');
    Route::resource('/newscategory', NewsCategoryController::class, ['names' => 'newscategory']);
    Route::resource('/news', NewsController::class, ['names' => 'news']);
    Route::resource('/blogcategory', BlogCategoryController::class, ['names' => 'blogcategory']);
    Route::resource('/blogs', BlogController::class, ['names' => 'blogs']);
    Route::resource('/reportcategory', ReportCategoryController::class, ['names' => 'reportcategory']);
    Route::resource('/reportsubcategory', ReportSubCategoryController::class, ['names' => 'reportsubcategory']);
    Route::resource('/report', ReportController::class, ['names' => 'report']);
    Route::resource('/apireport', ReportController::class, ['names' => 'apireport']);
    Route::resource('/faq', FaqController::class, ['names' => 'faq']);
    Route::resource('/newsletter', NewsletterController::class, ['names' => 'newsletter']);
    Route::resource('/blogComment', BlogCommentController::class, ['names' => 'blogComment']);
    Route::post('/blogComment/status', [BlogCommentController::class, 'updateStatus'])->name('blogComment.status');
    Route::resource('/newsComment', NewsCommentController::class, ['names' => 'newsComment']);
    Route::resource('/reportChart', ReportChartController::class, ['names' => 'reportChart']);
    Route::post('/newsComment/status', [NewsCommentController::class, 'updateStatus'])->name('newsComment.status');
    Route::resource('/ourSection', OurSectionController::class, ['names' => 'ourSection']);
    Route::post('/ourSection/status', [OurSectionController::class, 'updateStatus'])->name('ourSection.status');
    Route::resource('/career', CareerController::class, ['names' => 'career']);
    Route::resource('/enquiry', EnquiryController::class, ['names' => 'enquiry']);

    Route::resource('/testimonial', TestimonialController::class, ['names' => 'testimonial']);
    Route::post('/testimonial/status', [TestimonialController::class, 'updateStatus'])->name('testimonial.status');
    // Route::get('/reports', [ReportController::class, 'advSearchReport'])->name('report.advSearchReport');
    // Route::get('/report/{type}/{result}', [ReportController::class, 'advSearch'])->name('report.advSearch'); 
    // Route::get('/report/type/{type}', [ReportController::class, 'byType'])->name('report.by_type');
    Route::get('users', [\App\Http\Controllers\UserController::class, 'index'])->name('users.index');

    // Route::get('/apireportslist',[ApiReportController::class,'getreports'])->name('apireportlist.fetch');
    // Route::get('/apireportslist',[ApiReportController::class,'displayReportList'])->name('apireportlist.fetch');
    Route::resource('/apireportslist', ApiReportController::class, ['names' => 'apireportslist']);
    Route::get('/view_apireport_tables/{reportid}/{report_index}', [ApiReportController::class, 'viewTables'])->name('view_apitables');
    Route::get('/edit_apireport/{reportid}/{json_index}/{report_index}', [ApiReportController::class, 'editReport'])->name('edit_apireport');
    Route::get('/show_edit_apireport/{reportid}', [ApiReportController::class, 'showEditReport'])->name('show_edit_apireport');
    Route::post('/delete_apireport/{reportid}', [ApiReportController::class, 'editReport'])->name('delete_apireport');
    Route::put('/update_apireport/{id}', [ApiReportController::class, 'updateApiReport'])->name('apireports.update');
    Route::get('/get-subcategories/{categoryId}', [ApiReportController::class, 'getSubcategories'])->name('get_sub_categories');


});

Route::middleware('auth')->group(function () {
    Route::view('about', 'about')->name('about');
    Route::resource('/image', ImageController::class, ['names' => 'admin.image']);
    Route::post('/image/status', [ImageController::class, 'updateStatus'])->name('admin.image.status');
    Route::get('/generateSlug', [CommonController::class, 'generateSlug'])->name('generateSlug');
    Route::get('/getReportSubCategory', [CommonController::class, 'getReportSubCategory'])->name('getReportSubCategory');
    Route::get('/getReportadvanceSearch', [CommonController::class, 'getReportadvanceSearch'])->name('getReportadvanceSearch');

    Route::get('profile', [\App\Http\Controllers\ProfileController::class, 'show'])->name('profile.show');
    Route::put('profile', [\App\Http\Controllers\ProfileController::class, 'update'])->name('profile.update');
});
