<x-views.index-blade>
    <table class="table table-striped table-hover" id="commondatatable">
        <thead>
            <tr>
                <th scope="col">S.No</th>
                <th scope="col">Name</th>
                <th scope="col">Company</th>
                <th scope="col">Designation</th>
                <th scope="col">Description</th>
                <th scope="col">Image</th>
                <th scope="col">Status</th>
                <th scope="col">Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($testimonials as $testimonial)
                <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{ $testimonial->name }}</td>
                    <td>{{ $testimonial->company }}</td>
                    <td>{{ $testimonial->designation }}</td>
                    <td>{!! \Illuminate\Support\Str::limit($testimonial->description, 500, '...') !!}</td>
                    <td><img src="{{ $testimonial->image_url }}" width="50px;" hieght="50px;"></td>
                    <td><x-form.switch-component id="{{ $testimonial->id }}" value="{{ $testimonial->status }}" /></td>
                    <td class="d-flex">
                        <x-edit-button
                            route="{{ route($curr_url_1 . '.' . $curr_url_2 . '.edit', $testimonial->id) }}" />
                        <x-delete-button
                            action="{{ route($curr_url_1 . '.' . $curr_url_2 . '.destroy', $testimonial->id) }}" />
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
    @section('scripts')
        <script>
            const updateStatus = (id, checkbox) => {
                var status = checkbox.checked ? 1 : 0;
                $.ajax({
                    url: '{{ route('admin.testimonial.status') }}',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        id: id,
                        _token: "{{ csrf_token() }}",
                        status: status,
                    },
                    success: function(response) {
                        // Handle the success response
                        console.log('Status updated successfully');
                    },
                    error: function(error) {
                        // Handle the error response
                        console.error('Failed to update status');
                    }
                });
                showToast('Status updated successfully');
            }
        </script>
    @endsection
</x-views.index-blade>
