<x-views.edit-blade>
    <form method="post" action="{{ route($curr_url_1 . '.' . $curr_url_2 . '.update',$role->id) }}" @class(['p-4'])>
        @method('PUT')
        @csrf
        <x-form.input-component
            name="name"
            label="{{ ucfirst($curr_url_2) }} Name"
            placeholder="{{ ucfirst($curr_url_2) }} Name"
            value="{{ $role->name }}"
            required="true"
        />
        <button type="submit" class="btn btn-success mt-2">Save {{ ucfirst($curr_url_2) }}</button>
    </form>
    <div class="card">
        <div class="card-body">
            <div class="mt-4">
                <h2 class="m-0">Assign new Permission to this Role</h2>
                <form method="post" action="{{ route('admin.' . $curr_url_2 . '.permissions', $role->id) }}">
                    @csrf
                    <div class="form-floating mb-2">
                        {{-- <select required class="form-select form-select-lg my-1" name="permission"
                            aria-label=".form-select-lg example">
                            <option hidden value="">Permissions</option>
                            @foreach ($permissions as $permissions)
                            <option value="{{$permissions->name}}">{{$permissions->name}}</option>
                            @endforeach
                        </select>
                        @error('name')
                        <span class="text-danger">{{ $message }}
                            @enderror --}}
                        <x-form.input-component name="permission" label="Select Permission"
                        placeholder="Select Permission" :options="$permissions" type="select" required="true" />
                    </div>
                    <button type="submit" class="btn btn-success mb-3">Assign Permisson to
                        {{ ucfirst($curr_url_2) }}</button>
                </form>
                <h6 class="mt-4">Remove Permisson to {{ ucfirst($curr_url_2) }}</h6>
                <div class="d-flex">
                    @if ($role->permissions)
                    @foreach ($role->permissions as $role_permission)
                    <form method="POST" class="mx-2"
                        action="{{route('admin.'.$curr_url_2.'.permissions.revoke',[$role->id,$role_permission->id])}}"
                        onsubmit="return confirm('Are You Sure?');">
                        @csrf
                        @method('delete')
                        <button type="submit" class="btn bg-info text-white position-relative mt-2"> {{$role_permission->name}}
                            <span class=" position-absolute remove-cross-sec">
                                <span class="btn btn-close"></span>
                            </span>
                        </button>
                    </form>
                    @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-views.edit-blade>
