<x-views.create-blade label="Sub-Domain">
    <x-form.input-component name="category_id" label="Select Domain" placeholder="Select Domain"
        :options="$categories" type="select" required="true" value="{{ old('category_id') }}" />
    <x-form.input-component name="subcategory_title" label="Sub-Domain"
        placeholder="Sub-Domain" value="{{ old('subcategory_title') }}" required="true" />
        <x-form.input-component name="slug" label="Slug" placeholder="Slug" value="{{ old('slug') }}" required="true" />
        <label for="description">Description <span class="text-danger"> * </span> </label>
        <x-form.input-component name="description" type="textarea" class="ckeditor" label="Description"
        placeholder="Description" value="{{ old('description') }}" />
        <x-form.input-component name="subcat_icon" label="Icon"
            placeholder="Icon" value="{{ old('subcat_icon') }}" required="true" />
    <x-form.input-component name="seo_title" label="SEO Title" placeholder="SEO Title" value="{{ old('seo_title') }}"
        required="true" />
    <label for="meta_description">Meta Description <span class="text-danger"> * </span> </label>
    <x-form.input-component name="meta_description" type="textarea" label="Meta Description"
        placeholder="Meta Description" value="{{ old('meta_description') }}" />
    @section('scripts')
        <script>
            $('#subcategory_title').change(function(e) {
                var title = $(this).val();
                var modelName = 'ReportSubCategory';
                $.ajax({
                    type: 'GET',
                    url: '{{ route('generateSlug') }}',
                    data: {
                        title: title,
                        modelName: modelName
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#slug').val(data.slug);
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
        </script>
    @endsection
</x-views.create-blade>
