<x-views.index-blade label="Domain" >
    <table class="table table-striped table-hover" id="commondatatable">
        <thead>
            <tr>
                <th scope="col">S.No</th>
                <th scope="col">Domain</th>
                <th scope="col">Slug</th>
                <th scope="col">Description</th>
                <th scope="col">Image</th>
                <th scope="col">Icon</th>
                <th scope="col">Seo Title</th>
                <th scope="col">Meta Description</th>
                <th scope="col">Meta Keywords</th>
                <th scope="col">Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($reportcategory as $category)
                <tr>
                    <th scope="row">{{ $loop->iteration }}</th>
                    <td>{{ $category->category_title }}</td>
                    <td>{{ $category->slug }}</td>
                    <td>{!! \Illuminate\Support\Str::limit($category->description, 150, '...') !!}</td>
                    <td><img src='{{ $category->image }}' height='50px' width='50px' alt="{{ $category->category_title }}"></td>
                    <td>{{ $category->icon }}</td>
                    <td>{{ $category->seo_title }}</td>
                    <td>{{ $category->meta_description }}</td>
                    <td>{{ $category->meta_keyword }}</td>
                    <td class="d-flex">
                        <x-edit-button route="{{ route($curr_url_1 . '.' . $curr_url_2 . '.edit', $category->id) }}" />
                        <x-delete-button action="{{ route($curr_url_1 . '.' . $curr_url_2 . '.destroy', $category->id) }}" />
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</x-views.index-blade>
