<x-views.edit-blade label="Domain">
    <form method="post" action="{{ route($curr_url_1 . '.' . $curr_url_2 . '.update', $reportcategory->id) }}"
        @class(['p-4'])>
        @csrf
        @method('PUT')
        <x-form.input-component name="category_title" label="Domain"
            placeholder="Domain" value="{{ $reportcategory->category_title }}" required="true" />
        <x-form.input-component name="slug" label="Slug" placeholder="Slug" value=" {{ $reportcategory->slug }}"
            required="true" />
        <label for="description">Description <span class="text-danger"> * </span> </label>
        <x-form.input-component name="description" type="textarea" class="ckeditor" label="Description"
        placeholder="Description" value=" {!! $reportcategory->description !!}" />
        <x-form.input-component name="image" label="Image" placeholder="Image" value=" {{ $reportcategory->image }}"
            required="true" />
        <div id="image_Preview" class="m-5"></div>
        <x-form.input-component name="icon" label="Icon" placeholder="Icon" value=" {{ $reportcategory->icon }}"
            required="true" />
        <x-form.input-component name="seo_title" label="SEO Title" placeholder="SEO Title"
            value=" {{ $reportcategory->seo_title }}" required="true" />
        <label for="meta_description">Meta Description <span class="text-danger"> * </span> </label>
        <x-form.input-component name="meta_description" type="textarea" label="Meta Description"
            placeholder="Meta Description" value=" {!! $reportcategory->meta_description !!}" />
        <label for="meta_keywords">Meta Keywords</label>
        <x-form.input-component name="meta_keyword" type="textarea" label="Meta Keywords" placeholder="Meta Keywords"
            value=" {{ $reportcategory->meta_keyword }}" />
        <button type="submit" class="btn btn-success mt-2">Save {{ ucfirst($curr_url_2) }}</button>
    </form>
    @section('scripts')
        <script>
            $('#image').change(function(e) {
                var container = document.getElementById('image_Preview');
                container.innerHTML = "<img src='" + $('#image').val() +
                    "' alt='User's Image' height='50' width='50' >";
            });
            $('#category_title').change(function(e) {
                var title = $(this).val();
                var modelName = 'ReportCategory';

                $.ajax({
                    type: 'GET',
                    url: '{{ route('generateSlug') }}',
                    data: {
                        title: title,
                        modelName: modelName
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#slug').val(data.slug);
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
            $('#image').trigger('change');
        </script>
    @endsection
</x-views.edit-blade>
