<x-views.create-blade>
    {{-- @dd($categories) --}}
    <x-form.input-component name="category_id" label="Select Sub-Domain" placeholder="Select Sub-Domain"
        :options="$categories" type="select" required="true" value="{{ old('category_id') }}" />

    <x-form.input-component name="news_title" label="News Title" placeholder="News title" value="{{ old('news_title') }}"
        required="true" />
    <x-form.input-component name="slug" label="Slug" placeholder="Slug" value="{{ old('slug') }}"
        required="true" />
    <x-form.input-component name="image_url" label="Image Url" placeholder="Image Url" value="{{ old('image_url') }}"
        required="true" />
    <div id="image_Preview" class="m-5"></div>
    <x-form.input-component name="news_description" type="textarea" class="ckeditor" label="News Description"
        placeholder="News Description" value="{{ old('news_description') }}" />
    <x-form.input-component name="seo_title" label="SEO Title" placeholder="SEO Title" value="{{ old('seo_title') }}"
        required="true" />
    <label for="meta_description">Meta Description <span class="text-danger"> * </span> </label>
    <x-form.input-component name="meta_description" type="textarea" label="Meta Description"
        placeholder="Meta Description" value="{{ old('meta_description') }}" />
    <x-form.input-component name="p_date" type="date" label="Publish Date" placeholder="Publish Date"
        value="{{ old('p_date') }}" />
    @section('scripts')
        <script>
            $('#image_url').change(function(e) {
                var container = document.getElementById('image_Preview');
                container.innerHTML = "<img src='" + $('#image_url').val() +
                    "' alt='User's Image' height='50' width='50' >";
            });

            $('#news_title').change(function(e) {
                var title = $(this).val();
                var modelName = 'News';
                $.ajax({
                    type: 'GET',
                    url: '{{ route('generateSlug') }}',
                    data: {
                        title: title,
                        modelName: modelName
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#slug').val(data.slug);
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });

            var today = new Date();
            var dd = String(today.getDate()).padStart(2, '0');
            var mm = String(today.getMonth() + 1).padStart(2, '0'); // January is 0!
            var yyyy = today.getFullYear();

            today = yyyy + '-' + mm + '-' + dd;

            document.getElementById('p_date').value = today;
        </script>
    @endsection
</x-views.create-blade>
