<x-views.index-blade :addButton='false' >

    <form action="{{ route('admin.enquiry.index') }}" method="get" id='filter-form'>
        <div class="row row-cols-4">
            <div class="col">
                <x-form.input-component type="select" placeholder="Report" name="report_id" class="select2"
                    label="Report" :options="$reports" :value="request('report_id', '*')" />
            </div>
            <div class="col">
                <x-form.input-component name="category_id" label="Domain" placeholder="Domain"
                    :options="$categories" type="select" value="{{ request('category_id', old('category_id')) }}" />
            </div>
            <div class="col">
                <x-form.input-component name="subcategory_id" label="Sub-Domain" class="select2"
                    placeholder="Sub-Domain" :options="$subcats" type="select"
                    value="{{ request('subcategory_id', old('subcategory_id')) }}" />
            </div>
            <div class="col">
                <x-form.input-component name="country_code" label="Ph Code"
                    placeholder="Ph Code" value="{{ request('country_code', old('country_code')) }}" />
            </div>
            <div class="col">
                <x-form.input-component name="start_date" label="From Date"
                    placeholder="From Date" type="date" value="{{ request('start_date', old('start_date')) }}" />
            </div>
            <div class="col">
                <x-form.input-component name="end_date" label="End Date"
                    placeholder="End Date" type="date" value="{{ request('end_date', old('end_date')) }}" />
            </div>
            <div class="col">
                <x-form.input-component type="select" placeholder="Type" name="type" label="Type"
                    :options="[
                        'download sample' => 'download sample',
                    ]" :value="request('download sample', old('type'))" />
            </div>
            <div class="col">
                <button type="submit" id="search" class="btn btn-primary"><i class="fa fa-search" aria-hidden="true"></i>
                </button>
                <a href="{{ route('admin.enquiry.index') }}" class="btn btn-danger"> Reset </a>
            </div>
        </div>
    </form>

    {{ $dataTable->table(['class' => 'table table-bordered']) }}
    @section('scripts')
        {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
        <script>
            $('#category_id').change(function(e) {
                var category_id = $(this).val();
                $.ajax({
                    type: 'GET',
                    url: '{{ route('getReportSubCategory') }}',
                    data: {
                        category_id: category_id
                    },
                    dataType: 'json',
                    success: function(data) {
                        var selectBox = $('#subcategory_id');
                        selectBox.empty();
                        selectBox.append('<option value="" disabled selected>Sub-Domain</option>');
                        $.each(data.subcats, function(label, value) {
                            selectBox.append(`<option value="${value}"  > ${label}</option>`);
                        });
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
        </script>
    @endsection
</x-views.index-blade>
