<x-views.create-blade label="Blog Category">
    <x-form.input-component name="blog_category" label="{{ ucfirst($curr_url_2) }}"
        placeholder="{{ ucfirst($curr_url_2) }}" value="{{ old('blog_category') }}" required="true" />
    <x-form.input-component name="slug" label="Slug" placeholder="Slug" value="{{ old('slug') }}" required="true" />
    <label for="description">Description <span class="text-danger"> * </span> </label>
    <x-form.input-component name="description" type="textarea" class="ckeditor" label="Description"
        placeholder="Description" value="{{ old('description') }}" />
    <x-form.input-component name="seo_title" label="SEO Title" placeholder="SEO Title" value="{{ old('seo_title') }}"
        required="true" />
    <label for="meta_description">Meta Description <span class="text-danger"> * </span> </label>
    <x-form.input-component name="meta_description" type="textarea" label="Meta Description"
        placeholder="Meta Description" value="{{ old('meta_description') }}" />
    <label for="meta_keywords">Meta Keywords</label>
    <x-form.input-component name="meta_keywords" type="textarea" label="Meta Keywords" placeholder="Meta Keywords"
        value="{{ old('meta_keywords') }}" />
    @section('scripts')
        <script>
            $('#blog_category').change(function(e) {
                var title = $(this).val();
                var modelName = 'BlogCategory';

                $.ajax({
                    type: 'GET',
                    url: '{{ route('generateSlug') }}',
                    data: {
                        title: title,
                        modelName: modelName
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#slug').val(data.slug);
                    },
                    error: function(error) {
                        console.error('Ajax error:', error);
                    }
                });
            });
        </script>
    @endsection
</x-views.create-blade>
