@extends('layouts.app')
@section('content')
    @push('styles')
    @endpush
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title">
                    {{-- {{ $curr_url_1 ? ucfirst($curr_url_1) : '' }} --}}
                    {{ isset($label) ? $label : ($curr_url_2 ? ucfirst($curr_url_2) : '') }}
                </h5>
                
            </div>

            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th data-sortable="true">Report Name</th>
                        <th data-sortable="true">Table Name</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($selectedReports as $report)
                        <tr>
                            <td>{{ $report['reportname'] }}</td>
                            <td>{{ $report['tablename'] }}</td>
                            <td>
                            <div style="display: flex;gap: 20px;">
                            @if(isset($report['tablename']))
                                <a href="{{ route('admin.edit_apireport', ['reportid' => $report['reportid'], 'json_index' => $report['index'],'report_index' => $report['report_index']]) }}" class="btn btn-primary">
                                    <i class="fas fa-solid fa-eye"></i>
                                </a> 

                                @endif
                                @if(\App\Models\ApiReport::where('json_index', $report['index'])->exists())
                                    <!-- Show delete button -->
                                    <form action="{{ route('admin.delete_apireport', ['reportid' => $report['reportid']]) }}" method="post">
                                        @csrf
                                        @method('delete')
                                        <button type="submit" class="btn btn-danger"><i class="fas fa-solid fa-trash"></i></button>
                                    </form>
                                @endif

                               
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @push('scripts')
    @endpush
@endsection

