<?php

namespace Database\Seeders;

use App\Models\ReportCategory;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ReportCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        ReportCategory::create([
            'category_title' => 'Consumer Goods',
            'slug' => 'consumer-goods',
            'description' => '<p style="text-align:justify">The increasing consumer expenditure is the key contributor to growth of the retail and consumer goods sector. The emerging economies would be the epicenter that would be leading this growth and countries from Asia-Pacific and parts of middle-east would be acting as a catalyst for the same. There are dominant markets like Europe and North America that would provide stability the <strong>consumer goods market</strong>. With lot of changes in the latest consumer taste and preferences, we provide the upcoming industry trends with empirical insights on the impactful consumer behavior using a proven fact-finding method.</p>
            <p style="text-align:justify">We offer well researched and distinctive data to our clients from consumer goods markets and numerous companies, in order to make them understand the change in customer taste, the market demand patterns, latest industry trends, the competitor strategies and the forth coming industry potentials. Ensuring revenue expansion, we provide high-quality strategic solutions to the complexities encountered while managing the value chain analysis of consumer goods in an efficient manner.</p>

            <p style="text-align:justify">In line with the technological advancements and consumer expectations, we offer customized market research solutions to our clients and build an enhanced business growth. Looking into each point of sourcing, manufacturing, product development, sales, distribution and supply, we have an access to real-time data and viable insights. Some of the categories we report on include, consumer electronics, personal care &amp; cosmetics, home products, office products &amp; supplies, entertainment products, hospitality, retailing, baby products &amp; supplies, consumer &amp; general services, and others. &nbsp;&nbsp;&nbsp;</p>
            ',
            'image' => 'http://localhost/nextmsc/assets/images/5ced242909e36.jpg',
            'icon' => 'users',
            'seo_title' => 'Consumer Goods Market Research Report | NextMsc ',
            'meta_description' => "Acquire an detailed analysis report on consumer goods industry covering market research data and forecasts.",
            'meta_keyword' => 'Aerospace & Defense , Acquire, News, Industry Insights',
        ]);

        ReportCategory::create([
            'category_title' => 'Materials & Chemicals',
            'slug' => 'materials-chemicals',
            'description' => '<p style="text-align:justify">The materials and chemicals industry consist of bulk manufacturing of various materials and chemicals that act as a raw material for other products which plays an important role in the daily needs of a common man. Besides, it contributes a lot to the economic and industrial growth of a nation. There are many obstacles and strategies that would be extensively discussed in each of our reports regarding this market that would mainly include changing regulatory rules and regulations with price elasticity and the changing dynamics of the market among others.</p>

            <p style="text-align:justify">We look forward to enable constant growth opportunities to our clients by providing relevant information with competitive edge and the strategies followed by the leading players in the market. Our reports will enclose in-depth research and information from the diverse materials and chemical industries with insights on the technology, production process, and innovation. With the technology-driven landscape reaching the materials and chemicals industry, the leading players in the market look forward to achieve better connectivity between smart devices and equipment. We aid you in keeping up with the technological race with the recent developments and innovations, and provide the necessary business opportunities to shape your market growth.</p>

            <p>In the recent times, large number of companies are investing more on the carbon nanotubes, graphene, and quantum dots. Alongside, our reports enclose information on Renewable, specialty and fine chemicals, bulk chemicals, composites &amp; nanomaterials, advanced materials, agro-chemicals, paints, coatings and additives, biodegradable plastics, polymers &amp; elastomers, and others.</p>

            ',
            'image' => 'http://localhost/nextmsc/assets/images/5ced24700828c.jpg',
            'icon' => 'flask',
            'seo_title' => 'Materials and Chemicals Market Report | Nextmsc',
            'meta_description' => "Get a detailed analysis report on materials & chemicals industry covering market research data and forecasts from multiple publishers",
            'meta_keyword' => 'Aerospace & Defense , Acquire, News, Industry Insights',
        ]);

        ReportCategory::create([
            'category_title' => 'Construction & Manufacturing',
            'slug' => 'construction-manufacturing',
            'description' => '<p style="text-align:justify">From the evolution of mankind and after the discovery of man being a socialistic animal, there has been an ocean of changes that has lead us all where the world stands today. Rising metropolis and other emerging big cities across the globe have led to the growth of construction and manufacturing industry. This led with the ever increasing urban population in search jobs and better living has also boosted the overall industry. The major reasons for this fast growth are the overall growing population rate along with the growing economies. The emerging economies during their expansion will demand for considerable investments in manufacturing, construction and infrastructure.</p>

            <p style="text-align:justify">We provide an in-depth analysis and extensive pool of market data starting from the market size, revenue forecasts, product manufacturing &amp; price trends, competitive landscape, and others. Our clients have the access to assess the insights for strategizing, planning and execution of their business with our large data pool. The manufacturing process is driven by adoption of advanced automation technologies, adoption of advanced analytics with improvements in logistics efficiency. Our reports enclose the insights into recent technology advancements, emerging manufacturing trends, technological advances made in sensors and 3D technologies to improve plant productivity, investment made by large companies to boost their logistics efficiency and the factors that will impact the supply chain across regions.</p>

            <p style="text-align:justify">Comprehensive insights on several categories of construction and manufacturing industry include, construction materials, packaging, residential construction and improvement, heavy manufacturing, manufacturing services, roads &amp; highways, engineering, equipment &amp; machinery, and others.</p>
            ',
            'image' => 'http://localhost/nextmsc/assets/images/5ced241f2f0e4.jpg',
            'icon' => 'industry',
            'seo_title' => 'Construction & Manufacturing Market Report | Nextmsc',
            'meta_description' => "Get a detailed analysis report on construction & manufacturing industry covering market research data and forecasts from multiple publishers",
            'meta_keyword' => 'Aerospace & Defense , Acquire, News, Industry Insights',
        ]);
    }
}
