<?php

namespace Database\Seeders;

use App\Models\News;
use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class NewsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        News::create([
            'news_title' => 'Railway Traction Motor Market to Grow at 3.2% CAGR by 2030',
            'slug' => 'railway-traction-motor-market',
            'news_description' => '<p style="text-align:justify"><strong><em>Advancement in railway technologies, favorable government policies and increase in railway electrification projects are factors driving the growth of the railway traction motor market.</em></strong></p>

            <p style="text-align:justify">The <a href="https://www.nextmsc.com/report/railway-traction-motor-market">Global Railways Traction Motor Market</a> <a name="_Hlk65093779">was valued at USD 33.69 billion in 2019 and is projected to reach 47.64 billion by 2030, growing at a CAGR of 3.2% from 2020 to 2030.</a></p>

            <p style="text-align:justify">Railway traction motor is a specially designed motor for propelling locomotive. These motors provide effective torque and mechanical force, which is required for the effective functioning of the railway coaches due to their heavy weight and long-distance travel. The traction motor provides high torque at low speed and vice versa that acts as a key driver for the market growth and propulsion. However, high investment for designing and manufacturing traction motors may hinder the railways traction motors market growth.</p>

            <p style="text-align:justify">The global railway traction motor market is segmented based on type, application and geography. On the basis of type, the market is segmented into direct current traction motor, alternating current traction motor, and synchronous alternating current traction motor. On the basis of application, the market is divided into diesel locomotive, electric multiple units, electric locomotive, and direct electric locomotive. Geographic breakdown and analysis of each of the aforesaid segments includes regions comprising North America, Europe, Asia-Pacific, and RoW.</p>

            <p style="text-align:justify">North America is anticipated to hold the largest market share of railways traction motor market throughout the forecast period. This is attributable to the factors such as stringent government regulation to control pollution, developed infrastructure, and increased use of mono and metro rails in this region.</p>

            <p style="text-align:justify">Asia-Pacific is also expected to witness increasing market size with rapid growth rate owing to increasing focus on electrification of the railways, growth in tourism, which are expected to promote the market growth in this region.</p>

            <p style="text-align:justify">Browse Key Industry Insights from the Report,&rdquo; <strong><a href="https://www.nextmsc.com/report/railway-traction-motor-market">Railway Traction Motor Market by Type (Direct Current Traction Motors, Alternating Current Traction Motors, and Synchronous Alternating Current Traction Motor) and by Application (Diesel Locomotive, Electric Multiple Units, Electric Locomotives, and Diesel Electric Locomotives) - Global Opportunities Analysis and Industry Forecast, 2020-2030.</a></strong>&rdquo;</p>

            <p style="text-align:justify">The railway traction motor market is highly competitive and consists of various market players. Some of the major market players include Aisin Seiki Co. Ltd., Bombardier Inc., Mitsubishi Electric Corporation, Saini Heavy Electrical &amp; Engineering Co Private Ltd., Hyundai Rotem Company, ALSTOM, Bharat Heavy Electricals Ltd., Sulzer Ltd., Zytek Automotive Ltd., VEM Sachsenwerk GmbH, and ABB Group among others.&nbsp;</p>

            <p style="text-align:justify"><strong>Key Insights from the Railway Traction Motor Market:</strong></p>

            <ul>
                <li style="text-align:justify">
                <p>This report provides an extensive analysis of the current and emerging market trends and dynamics in the railway traction motor market.</p>
                </li>
                <li style="text-align:justify">
                <p>In-depth analysis of the industry is conducted by constructing market estimations for the key market segments between 2020 and 2030.</p>
                </li>
                <li style="text-align:justify">
                <p>Extensive analysis is conducted by studying the key product positioning and monitoring the top competitors within the market framework.</p>
                </li>
            </ul>

            <p style="text-align:justify"><strong><a href="https://www.nextmsc.com/railway-traction-motor-market/request-sample">Get a Free Sample on Railway Traction Motor Market Report.</a></strong></p>

            <p style="text-align:justify"><strong>About Next Move Strategy Consulting</strong></p>

            <p style="text-align:justify">Next Move Strategy Consulting is an independent and trusted third-platform market intelligence provider, committed to deliver high quality, market research reports that help multinational companies to triumph over their competitions and increase industry footprint by capturing greater market share. Our research model is a unique collaboration of primary research, secondary research, data mining and data analytics.</p>

            <p style="text-align:justify">We have been servicing over 1000 customers globally that includes 90% of the Fortune 500 companies over a decade. Our analysts are constantly tracking various high growth markets and identifying hidden opportunities in each sector or the industry. We provide one of the industry&rsquo;s best quality syndicate as well as custom research reports across 10 different industry verticals. We are committed to deliver high quality research solutions in accordance to your business needs. Our industry standard delivery solutions that ranges from the pre consultation to after-sales services, provide an excellent client experience and ensure right strategic decision making for businesses.</p>

            <p>For more insights, please visit,&nbsp;<a href="https://www.nextmsc.com">https://www.nextmsc.com</a></p>
            ',
            'image_url' => 'https://www.nextmsc.com/assets/frontend/images/NM02.png',
            'seo_title' => 'Railway Traction Motor Market to Grow at 3.2% CAGR by 2030',
            'meta_description' => 'The Global Railways Traction Motor Market was valued at USD 33.69 billion in 2019 and is projected to reach 47.64 billion by 2030, growing at a CAGR of 3.2% from 2020 to 2030',
            'p_date' => Carbon::now(),
            'category_id' => 2, // Adjust the category_id based on your existing category
        ]);
    }
}
