<?php

namespace Database\Seeders;

use App\Models\NewsCategory;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class NewsCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        NewsCategory::create([
            'news_category' => 'Aerospace and Defense',
            'slug' => 'aerospace-and-defense',
            'description' => '<p><strong>Aerospace and Defense</strong></p>',
            'seo_title' => 'Defying Boundaries: Aerospace & Defense News by NMSC',
            'meta_description' => "Stay ahead in the world of business and technology with NMSC's insightful news. Get the latest updates and practical insights on Aerospace & Defense Industry",
            'meta_keywords' => 'Aerospace & Defense Market Research Blogs, News, Industry Insights',
        ]);
        NewsCategory::create([
            'news_category' => 'Automotive and Transportation',
            'slug' => 'automotive-and-transportation',
            'description' => '<p>Automotive and Transportation</p>',
            'seo_title' => 'Automotive and Transportation | News',
            'meta_description' => "Automotive and Transportation | News"
        ]);
        NewsCategory::create([
            'news_category' => 'Construction & Manufacturing',
            'slug' => 'construction-manufacturing',
            'description' => '<p>Construction &amp; Manufacturing</p>',
            'seo_title' => 'Construction and Manufacturing | News',
            'meta_description' => "Construction and Manufacturing | News"
        ]);
    }
}
