<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_charts', function (Blueprint $table) {
            $table->id();
            $table->json('year_data');
            $table->string('start_year');
            $table->string('end_year');
            $table->string('unit');
            $table->text('segments');
            $table->string('region');
            $table->string('reg_value');
            $table->string('value_show');
            $table->foreignId('report_id')->constrained('reports')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('report_charts');
    }
};
