<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('type');
            $table->foreignId('category_id')->constrained('report_categories')->onDelete('cascade');
            $table->foreignId('subcategory_id')->constrained('report_sub_categories')->onDelete('cascade');
            $table->string('slug')->unique();
            $table->mediumText('report_title');
            $table->string('report_name');
            $table->string('pages');
            $table->string('no_of_table');
            $table->string('figure');
            $table->longText('description');
            $table->longText('industry_glance');
            $table->longText('research_scope');
            $table->longText('toc');
            $table->string('price');
            $table->string('corporate_cost');
            $table->string('enterprise_cost');
            $table->dateTime('p_date');
            $table->string('region');
            $table->string('seo_title');
            $table->longText('meta_description');
            $table->string('meta_keyword')->nullable();
            $table->string('image_path1')->nullable();
            $table->string('image_path2')->nullable();
            $table->string('image_path3')->nullable();
            $table->text('video_path')->nullable();
            $table->mediumText('write_up')->nullable();
            $table->string('chart_type')->nullable();
            $table->string('coupon_code')->nullable();
            $table->integer('coupon_discount')->nullable();
            $table->date('published_date')->nullable();
            $table->date('expired_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reports');
    }
};
