<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
class ReportSubCategory extends Model
{
    use HasFactory, LogsActivity;
    protected $fillable = [
        "category_id",
        "subcategory_title",
        "subcat_icon",
        "slug",
        "description",
        "seo_title",
        "meta_description",
    ] ;

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('report_sub_categories')
        ->dontLogIfAttributesChangedOnly(['updated_at'])
        ->logOnlyDirty()
        ->logFillable();
        // ->logOnly(['name', 'text']);
        // Chain fluent methods for configuration options
    }
    public function reportCategory(): BelongsTo
    {
        return $this->belongsTo(ReportCategory::class, 'category_id');
    }
    public function blog(): HasMany
    {
        return $this->hasMany(Blog::class, 'category_id');
    }
    public function news(): HasMany
    {
        return $this->hasMany(News::class, 'category_id');
    }
    public function reports(): HasMany
    {
        return $this->hasMany(Report::class, 'subcategory_id');
    }

}
