<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;
class ReportCategory extends Model
{
    use HasFactory, LogsActivity;
    protected $fillable = [
        "category_title",
        "slug",
        "description",
        "image",
        "icon",
        "seo_title",
        "meta_description",
        "meta_keywords",
    ] ;
    public function reportSubCategory(): HasMany
    {
        return $this->hasMany(ReportSubCategory::class, 'category_id');
    }
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('report_categories')
        ->dontLogIfAttributesChangedOnly(['updated_at'])
        ->logOnlyDirty()
        ->logFillable();
        // ->logOnly(['name', 'text']);
        // Chain fluent methods for configuration options
    }
}
