<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
class Report extends Model
{
    use HasFactory, LogsActivity;
    protected $fillable = [
        "type",
        "category_id",
        "subcategory_id",
        "slug",
        "report_title",
        "report_name",
        "pages",
        "no_of_table",
        "figure",
        "description",
        "industry_glance",
        "research_scope",
        "toc",
        "price",
        "corporate_cost",
        "enterprise_cost",
        "p_date",
        "region",
        "seo_title",
        "meta_keyword",
        "meta_description",
        "image_path1",
        "image_path2",
        "image_path3",
        "video_path",
        "write_up",
        "chart_type",
        "coupon_code",
        "coupon_discount",
        "published_date",
        "expired_date",
    ] ;
    protected $casts = [
        'p_date' => 'datetime',
    ];

    public function getFormattedPDateAttribute()
    {
        return $this->attributes['p_date'] ? Carbon::parse($this->attributes['p_date'])->format('d-M-Y') : null;
    }
    public function reportCategory(): BelongsTo
    {
        return $this->belongsTo(ReportCategory::class, 'category_id');
    }
    public function reportSubCategory(): BelongsTo
    {
        return $this->belongsTo(ReportSubCategory::class, 'subcategory_id');
    }

    public function faqs(): HasMany
    {
        return $this->hasMany(Faq::class, 'report_id');
    }
    public function enquiry(): HasMany
    {
        return $this->hasMany(Enquiry::class, 'report_id');
    }
    public function reportChart(): HasOne
    {
        return $this->HasOne(ReportChart::class, 'report_id')->withDefault();
    }

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('reports')
        ->dontLogIfAttributesChangedOnly(['updated_at'])
        ->logOnlyDirty()
        ->logFillable();
        // ->logOnly(['name', 'text']);
        // Chain fluent methods for configuration options
    }
}
