<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
class Enquiry extends Model
{
    use HasFactory;
    protected $fillable = [
        "name",
        "email",
        "country_code",
        "phone",
        "message",
        "type",
        "reffer",
        "report_id",
    ];

    public function report(): BelongsTo
    {
        return $this->belongsTo(Report::class, 'report_id');
    }
}
