<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;
class Career extends Model
{
    use HasFactory,LogsActivity;
    protected $fillable = [
        "title",
        "summary",
        "responsiblity",
        "skills",
        "location",
        "job_type",
    ] ;
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
        ->useLogName('careers')
        ->dontLogIfAttributesChangedOnly(['updated_at'])
        ->logOnlyDirty()
        ->logFillable();
    }
}
