<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class NewsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'news_title' => 'required|string',
            'news_description' => 'required|string',
            'seo_title' => 'required|string',
            'meta_description' => 'required|string',
            'p_date' => 'required',
            'category_id' => 'required',
        ];
        if ($this->isMethod('put') || $this->isMethod('patch')) {
            $rules['slug'] = 'required|string|unique:news,slug,' . $this->route('news')->id;
        } else {
            $rules['slug'] = 'required|string|unique:news';
        }

        return $rules;
    }
}
