<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class NewsCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'news_category' => 'required|string',
            'description' => 'required|string',
            'seo_title' => 'required|string',
            'meta_description' => 'required|string',
        ];
        if ($this->isMethod('put') || $this->isMethod('patch')) {
            $newsCategoryId = $this->route('newscategory')->id;
            // dd($newsCategoryId);
            $rules['slug'] = 'required|string|unique:news_categories,slug,' . $newsCategoryId;
        } else {
            $rules['slug'] = 'required|string|unique:news_categories';
        }
        return $rules;
    }
}
