<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BlogCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'blog_category' => 'required|string',
            'description' => 'required|string',
            'seo_title' => 'required|string',
            'meta_description' => 'required|string',
        ];
        if ($this->isMethod('put') || $this->isMethod('patch')) {
            $blogCategoryId = $this->route('blogcategory')->slug;
            // dd($blogCategoryId);
            $rules['slug'] = 'required|string|unique:blogs,slug,' . $blogCategoryId;
        } else {
            $rules['slug'] = 'required|string|unique:blogs';
        }
        return $rules;
    }
}
