<?php

namespace App\Http\Controllers;

use App\Models\ReportSubCategory;
use App\Http\Requests\ReportSubCategoryRequest;
use App\Models\ReportCategory;

class ReportSubCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $reportsubcategory = ReportSubCategory::with('reportCategory')->latest()->get();
        return view('admin.reportsubcategory.index', compact('reportsubcategory'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $categories = ReportCategory::pluck('id','category_title')->toArray();
        return view('admin.reportsubcategory.create', compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ReportSubCategoryRequest $request)
    {
        ReportSubCategory::create($request->validated());
        return redirect()->route('admin.reportsubcategory.index')->with('success', 'Report SubCategory created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(ReportSubCategory $reportSubCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ReportSubCategory $reportsubcategory)
    {
        $categories = ReportCategory::pluck('id','category_title')->toArray();
        return view('admin.reportsubcategory.edit', compact(['reportsubcategory','categories']));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ReportSubCategoryRequest $request, ReportSubCategory $reportsubcategory)
    {
        $reportsubcategory->update($request->validated());
        return redirect()->route('admin.reportsubcategory.index')->with('success', 'Report SubCategory Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ReportSubCategory $reportsubcategory)
    {
        $reportsubcategory->delete();
        return back()->with('success', 'Report SubCategory Deleted Successfully');
    }
}
