<?php

namespace App\Http\Controllers;

use App\Models\Report;
use App\DataTables\ReportDataTable;
use App\Http\Requests\ReportRequest;
use App\Models\ReportCategory;
use App\Models\ReportSubCategory;
use Illuminate\Http\Request;
class ReportController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(ReportDataTable $dataTable)
    {
        $categories=ReportCategory::pluck('id','category_title')->toArray();
        $subcats=ReportSubCategory::pluck('id', 'subcategory_title')->toArray();
        return $dataTable->render('admin.report.index', compact('categories','subcats'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $categories=ReportCategory::pluck('id','category_title')->toArray();
        // $subcategories=ReportSubCategory::pluck('id','subcategory_title')->toArray();
        return view('admin.report.create', compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ReportRequest $request)
    {
       $report = Report::create($request->validated());
        return redirect()->route('admin.report.edit', $report->id)->with('success', 'Report created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Report $report)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Report $report)
    {
        $categories=ReportCategory::pluck('id','category_title')->toArray();
        $faqs= $report->faqs;
        $reportChart= $report->reportChart;
        return view('admin.report.edit', compact('report','categories','faqs','reportChart'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ReportRequest $request, Report $report)
    {
        $report->update($request->validated());
        return redirect()->route('admin.report.index')->with('success', 'Report Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Report $report)
    {
        //
    }


    // public function advSearch(ReportDataTable $dataTable, $type,$val)
    // {
    //     return $dataTable->setTypeFilter($type,$val)->render('admin.report.index');
    // }

}
