<?php

namespace App\Http\Controllers;

use App\Models\ReportChart;
use Illuminate\Http\Request;

class ReportChartController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $year_data = collect($request->all())
            ->filter(function ($value, $key) {
                return strpos($key, 'values-') === 0;
            })
            ->toArray();
echo "<pre>";
print_r($year_data);
echo "</pre>";
        $firstValue = null;
        $lastValue = null;
        foreach ($year_data as $key => $value) {
            if ($value !== null) {
                if ($firstValue === null) {
                    $firstValue = $value;
                }
                $lastValue = $value;
            }
        }
        $count = count($year_data);
        $step = $firstValue !== null ? ($lastValue - $firstValue) / ($count - 1) : 0;
        $i = 0;
        foreach ($year_data as $key => $value) {
            if (isset($value) || $value === null) {
                if ($value !== $firstValue && $value !== $lastValue) {
                    $year_data[$key] = intval($firstValue + $i * $step);
                }
            }
            $i++;
        }
        // dd($year_data);
        // Use $year_data as needed


        ReportChart::updateOrCreate(
            [
                'report_id' => $request->report_id
            ],
            [
                'report_id' => $request->input('report_id'),
                'unit' => $request->input('unit'),
                'start_year' => $request->input('start_year'),
                'end_year' => $request->input('end_year'),
                'segments' => $request->input('segments'),
                'region' => $request->input('region'),
                'reg_value' => $request->input('reg_value'),
                'value_show' => $request->input('value_show'),
                'year_data' => json_encode($year_data),
            ]
        );
        return redirect()->route('admin.report.index')->with('success', 'Report Chart Created/Updated successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(ReportChart $reportChart)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ReportChart $reportChart)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ReportChart $reportChart)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ReportChart $reportChart)
    {
        //
    }

    public function convertChart()
    {
    }
}
