<?php

namespace App\Http\Controllers;

use App\Models\News;
use App\Http\Requests\NewsRequest;
use App\DataTables\NewsDataTable;
use App\Models\ReportCategory;
use App\Models\ReportSubCategory;

class NewsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(NewsDataTable $dataTable)
    {
        $domains=ReportCategory::pluck('id','category_title')->toArray();
        $categories=ReportSubCategory::pluck('id','subcategory_title')->toArray();
        return $dataTable->render('admin.news.index',compact('categories','domains'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $categories = ReportSubCategory::pluck('id','subcategory_title')->toArray();
        return view('admin.news.create', compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(NewsRequest $request)
    {
        News::create($request->validated());
        return redirect()->route('admin.news.index')->with('success', 'News added successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(News $news)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(News $news)
    {
        $categories = ReportSubCategory::pluck('id','subcategory_title')->toArray();
        return view('admin.news.edit', compact(['news','categories']));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(NewsRequest $request, News $news)
    {
        $news->update($request->validated());
        return redirect()->route('admin.news.index')->with('success', 'News Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(News $news)
    {
        $news->delete();
        return back()->with('success', 'News Deleted Successfully');
    }
}
