<?php

namespace App\Http\Controllers;

use App\Models\NewsCategory;
use App\Http\Requests\NewsCategoryRequest;

class NewsCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $newscategory = NewsCategory::latest()->get();
        return view('admin.newscategory.index', compact('newscategory'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.newscategory.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(NewsCategoryRequest $request)
    {
        NewsCategory::create($request->validated());
        return redirect()->route('admin.newscategory.index')->with('success', 'News category created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(NewsCategory $newsCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(NewsCategory $newscategory)
    {
        return view('admin.newscategory.edit', compact('newscategory'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(NewsCategoryRequest $request, NewsCategory $newscategory)
    {
        $newscategory->update($request->validated());
        return redirect()->route('admin.newscategory.index')->with('success', 'News category Updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(NewsCategory $newscategory)
    {
        $newscategory->delete();
        return back()->with('success', 'News category Deleted Successfully');
    }

}
