<?php

namespace App\Http\Controllers;

use App\DataTables\ImageDataTable;
use App\Models\Image;
use App\Http\Requests\ImageRequest;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
class ImageController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(ImageDataTable $dataTable)
    {
        return $dataTable->ajax();
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ImageRequest $request)
    {
        $disk='images';
        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $baseSlug="";
            if ($request->filled('title')) {
                $baseSlug .= Str::slug($request->input('title'));
            } else {
                $baseSlug .= pathinfo($image->hashName(), PATHINFO_FILENAME);
            }
            $counter = 1;
            $slug = $baseSlug .'.'.$image->getClientOriginalExtension();

            while (Image::where('slug', $slug)->exists()) {
                $counter++;
                $slug = $baseSlug . '-' . $counter .'.'.$image->getClientOriginalExtension();;
            }
            Storage::disk($disk)->put($slug,file_get_contents($image));
            $url = Storage::disk($disk)->url($slug);
            $url = str_replace('s3.amazonaws.com//', 's3.amazonaws.com/', $url);
            $url = str_replace( $disk.'//', $disk.'/', $url);
            // $path = $image->storeAs('', $slug);
            $imageModel = new Image([
                'title' => $request->input('title'),
                'slug' => $slug,
                'disk' => $disk,
                'image_url' => $url,
            ]);
            $imageModel->save();
            return response()->json(['message' => $slug. 'Image successfully uploaded.' .  $url]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Image $image)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Image $image)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ImageRequest $request, Image $image)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Image $image)
    {
        Storage::disk($image->disk)->delete($image->slug);
        $image->delete();
        return back()->with('success', 'Image Deleted Successfully');
    }

    public function updateStatus(Request $request)
    {
        $image=Image::findorfail($request->id);
        $image->status = $request->status;
        $image->save();
    }
}
