<?php

namespace App\Http\Controllers;

use App\DataTables\EnquiryDataTable;
use App\Models\Enquiry;
use App\Http\Requests\EnquiryRequest;

class EnquiryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(EnquiryDataTable $dataTable)
    {
        $reports=  \App\Models\Report::pluck('id','report_title')->toArray();
        $categories= \App\Models\ReportCategory::pluck('id','category_title')->toArray();
        $subcats= \App\Models\ReportSubCategory::pluck('id', 'subcategory_title')->toArray();
        return $dataTable->render('admin.enquiry.index',compact(['reports','categories','subcats']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(EnquiryRequest $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Enquiry $enquiry)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Enquiry $enquiry)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(EnquiryRequest $request, Enquiry $enquiry)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Enquiry $enquiry)
    {
        //
    }
}
