<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
class PermissionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $permissions=Permission::all();
        return view('admin.permissions.index',compact('permissions'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.permissions.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name'=>['required','min:3','unique:permissions'],
        ]);
        Permission::create($validated);
        return to_route('admin.permissions.index')->with('success','Permission Created Successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(Permission $permission)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Permission $permission)
    {
        $roles = Role::pluck('name','name')->toArray();
        return view('admin.permissions.edit', compact(['permission','roles']));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Permission $permission)
    {
        $validated = $request->validate([
            'name'=>['required','min:3', 'unique:permissions,name,' . $permission->id],
        ]);
        $permission->update($validated);
        return to_route('admin.permissions.index')->with('success','Permission Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Permission $permission)
    {
        $permission->delete();
        return back()->with('success','Permission Deleted Successfully');
    }
    public function assignRole(Request $request, Permission $permission){
        if ($permission->hasRole($request->role)){

            return back()->with('error','Role Already exists !');
        }else{
            $permission->assignRole($request->role);
            return back()->with('success','Role Assigned Successfully');
        }
    }
    public function removeRole(Permission $permission, Role $role){
        if ($permission->hasRole($role)){
            $permission->removeRole($role);
            return back()->with('success','Role Removed Successflly.');
        }else{
            return back()->with('error','Permission Not exist for this role');
        }
    }
}
